package com.example.tp6_02.dto;

import com.example.tp6_02.model.City;
import com.example.tp6_02.model.WeatherCondition;

import java.util.ArrayList;
import java.util.List;

public class Mapper {
    public static WeatherCondition weatherConditionDTO2WeatherCondition(WeatherConditionDTO weatherConditionDTO) throws NullPointerException {
        WeatherCondition data = null;
        data = new WeatherCondition(weatherConditionDTO.getDate(), weatherConditionDTO.getMin(), weatherConditionDTO.getMax(), weatherConditionDTO.getIcon());
        return data;
    }

    public static City cityDTO2city(CityDTO cityDTO) throws NullPointerException {
        City data = null;
        if (cityDTO == null) {
            data = new City();

        } else {
            List<WeatherConditionDTO> weatherDTO = cityDTO.getWeather();
            List<WeatherCondition> weather = new ArrayList<WeatherCondition>();
            for (WeatherConditionDTO dayDTO : weatherDTO) {
                WeatherCondition day = weatherConditionDTO2WeatherCondition(dayDTO);
                weather.add(day);
            }
            data = new City(cityDTO.getName(), weather);
        }
        return data;
    }

}
